PSA Cryptograpy API implementation and PSA driver interface
===========================================================

## Introduction

The [PSA Cryptography API specification](https://armmbed.github.io/mbed-crypto/psa/#application-programming-interface) defines an interface to cryptographic operations which the Mbed TLS library provides a reference implementation for. The PSA Cryptography API specification is complemented by the PSA driver interface specification which defines an interface for cryptoprocessor drivers.

This document describes the high level organization of the Mbed TLS PSA Cryptography API implementation which is tighly related to the PSA driver interface.

## High level organization of the Mbed TLS PSA Cryptography API implementation
In one sentence, the Mbed TLS PSA Cryptography API implementation is made of a core and PSA drivers as defined in the PSA driver interface. The key point is that software cryptographic operations are organized as PSA drivers: they interact with the core through the PSA driver interface.

### Rationale

* Addressing software and hardware cryptographic implementations through the same C interface reduces the core code size and its call graph complexity. The core and its dispatching to software and hardware implementations are consequently easier to test and validate.
* The organization of the software cryptographic implementations in drivers promotes modularization of those implementations.
* As hardware capabilities, software cryptographic functionalities can be described by a JSON driver description file as defined in the PSA driver interface.
* Along with JSON driver description files, the PSA driver specification defines the deliverables for a driver to be included into the Mbed TLS PSA Cryptography implementation. This provides a natural framework to integrate third party or alternative software implementations of cryptographic operations.

## The Mbed TLS PSA Cryptography API implementation core

The core implements all the APIs as defined in the PSA Cryptography API specification but do not perform on its own any cryptographic operation. The core relies on PSA drivers to actually
perform the cryptographic operations. The core is responsible of:

* the key store.
* checking PSA API arguments and translate them into valid arguments for the necessary calls to the PSA driver interface.
* dispatchng the cryptographic operations to the appropriate PSA drivers.

The sketch of an Mbed TLS PSA cryptographic API implementation is thus:
```C                                                                            
psa_status_t psa_api( ... )
{
    psa_status_t status;

    /* Pre driver interface call processing: validation of arguments, building
     * of arguments for the call to the driver interface, ... */

    ...

    /* Call to the driver interface */
    status = psa_driver_wrapper_<entry_point>( ... );
    if( status != PSA_SUCCESS )
        return( status );

    /* Post driver interface call processing: validation of the values returned
     * by the driver, finalization ot the values to return to the caller,
     * clean-up in case of error ... */
}
```
Obviously, for some PSA APIs the implementation is more complicated with several potential conditionnal calls to different driver entry points but most of PSA API code aimed to be organized along those lines. The implementation of the `psa_driver_wrapper_<entry_point>` function is generated by the build system based on the JSON driver description files of the various PSA drivers making up the Mbed TLS PSA Cryptography API implementation.
