## Removed features

### Removal of obsolete key exchanges methods in (D)TLS 1.2

Mbed TLS 4.0 no longer supports key exchange methods that rely on finite-field Diffie-Hellman (DHE) in TLS 1.2 and DTLS 1.2. (Only ephemeral Diffie-Hellman was ever supported, Mbed TLS 3.x already did not support static Diffie-Hellman.) Finite-field Diffie-Hellman remains supported in TLS 1.3.

Mbed TLS 4.0 no longer supports key exchange methods that rely on RSA decryption (without forward secrecy). RSA signatures remain supported. This affects TLS 1.2 and DTLS 1.2 (TLS 1.3 does not have key exchanges using RSA decryption).

That is, the following key exchange types are no longer supported:

* RSA-PSK;
* RSA (i.e. cipher suites using only RSA decryption: cipher suites using RSA signatures remain supported);
* DHE-PSK (except in TLS 1.3);
* DHE-RSA (except in TLS 1.3).
* static ECDH (ECDH-RSA and ECDH-ECDSA, as opposed to ephemeral ECDH (ECDHE) which remains supported).

The full list of removed cipher suites is:

```
TLS-DHE-PSK-WITH-AES-128-CBC-SHA
TLS-DHE-PSK-WITH-AES-128-CBC-SHA256
TLS-DHE-PSK-WITH-AES-128-CCM
TLS-DHE-PSK-WITH-AES-128-CCM-8
TLS-DHE-PSK-WITH-AES-128-GCM-SHA256
TLS-DHE-PSK-WITH-AES-256-CBC-SHA
TLS-DHE-PSK-WITH-AES-256-CBC-SHA384
TLS-DHE-PSK-WITH-AES-256-CCM
TLS-DHE-PSK-WITH-AES-256-CCM-8
TLS-DHE-PSK-WITH-AES-256-GCM-SHA384
TLS-DHE-PSK-WITH-ARIA-128-CBC-SHA256
TLS-DHE-PSK-WITH-ARIA-128-GCM-SHA256
TLS-DHE-PSK-WITH-ARIA-256-CBC-SHA384
TLS-DHE-PSK-WITH-ARIA-256-GCM-SHA384
TLS-DHE-PSK-WITH-CAMELLIA-128-CBC-SHA256
TLS-DHE-PSK-WITH-CAMELLIA-128-GCM-SHA256
TLS-DHE-PSK-WITH-CAMELLIA-256-CBC-SHA384
TLS-DHE-PSK-WITH-CAMELLIA-256-GCM-SHA384
TLS-DHE-PSK-WITH-CHACHA20-POLY1305-SHA256
TLS-DHE-PSK-WITH-NULL-SHA
TLS-DHE-PSK-WITH-NULL-SHA256
TLS-DHE-PSK-WITH-NULL-SHA384
TLS-DHE-RSA-WITH-AES-128-CBC-SHA
TLS-DHE-RSA-WITH-AES-128-CBC-SHA256
TLS-DHE-RSA-WITH-AES-128-CCM
TLS-DHE-RSA-WITH-AES-128-CCM-8
TLS-DHE-RSA-WITH-AES-128-GCM-SHA256
TLS-DHE-RSA-WITH-AES-256-CBC-SHA
TLS-DHE-RSA-WITH-AES-256-CBC-SHA256
TLS-DHE-RSA-WITH-AES-256-CCM
TLS-DHE-RSA-WITH-AES-256-CCM-8
TLS-DHE-RSA-WITH-AES-256-GCM-SHA384
TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256
TLS-DHE-RSA-WITH-ARIA-128-GCM-SHA256
TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384
TLS-DHE-RSA-WITH-ARIA-256-GCM-SHA384
TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA
TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256
TLS-DHE-RSA-WITH-CAMELLIA-128-GCM-SHA256
TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA
TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256
TLS-DHE-RSA-WITH-CAMELLIA-256-GCM-SHA384
TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256
TLS-ECDH-ECDSA-WITH-AES-128-CBC-SHA
TLS-ECDH-ECDSA-WITH-AES-128-CBC-SHA256
TLS-ECDH-ECDSA-WITH-AES-128-GCM-SHA256
TLS-ECDH-ECDSA-WITH-AES-256-CBC-SHA
TLS-ECDH-ECDSA-WITH-AES-256-CBC-SHA384
TLS-ECDH-ECDSA-WITH-AES-256-GCM-SHA384
TLS-ECDH-ECDSA-WITH-ARIA-128-CBC-SHA256
TLS-ECDH-ECDSA-WITH-ARIA-128-GCM-SHA256
TLS-ECDH-ECDSA-WITH-ARIA-256-CBC-SHA384
TLS-ECDH-ECDSA-WITH-ARIA-256-GCM-SHA384
TLS-ECDH-ECDSA-WITH-CAMELLIA-128-CBC-SHA256
TLS-ECDH-ECDSA-WITH-CAMELLIA-128-GCM-SHA256
TLS-ECDH-ECDSA-WITH-CAMELLIA-256-CBC-SHA384
TLS-ECDH-ECDSA-WITH-CAMELLIA-256-GCM-SHA384
TLS-ECDH-ECDSA-WITH-NULL-SHA
TLS-ECDH-RSA-WITH-AES-128-CBC-SHA
TLS-ECDH-RSA-WITH-AES-128-CBC-SHA256
TLS-ECDH-RSA-WITH-AES-128-GCM-SHA256
TLS-ECDH-RSA-WITH-AES-256-CBC-SHA
TLS-ECDH-RSA-WITH-AES-256-CBC-SHA384
TLS-ECDH-RSA-WITH-AES-256-GCM-SHA384
TLS-ECDH-RSA-WITH-ARIA-128-CBC-SHA256
TLS-ECDH-RSA-WITH-ARIA-128-GCM-SHA256
TLS-ECDH-RSA-WITH-ARIA-256-CBC-SHA384
TLS-ECDH-RSA-WITH-ARIA-256-GCM-SHA384
TLS-ECDH-RSA-WITH-CAMELLIA-128-CBC-SHA256
TLS-ECDH-RSA-WITH-CAMELLIA-128-GCM-SHA256
TLS-ECDH-RSA-WITH-CAMELLIA-256-CBC-SHA384
TLS-ECDH-RSA-WITH-CAMELLIA-256-GCM-SHA384
TLS-ECDH-RSA-WITH-NULL-SHA
TLS-RSA-PSK-WITH-AES-128-CBC-SHA
TLS-RSA-PSK-WITH-AES-128-CBC-SHA256
TLS-RSA-PSK-WITH-AES-128-GCM-SHA256
TLS-RSA-PSK-WITH-AES-256-CBC-SHA
TLS-RSA-PSK-WITH-AES-256-CBC-SHA384
TLS-RSA-PSK-WITH-AES-256-GCM-SHA384
TLS-RSA-PSK-WITH-ARIA-128-CBC-SHA256
TLS-RSA-PSK-WITH-ARIA-128-GCM-SHA256
TLS-RSA-PSK-WITH-ARIA-256-CBC-SHA384
TLS-RSA-PSK-WITH-ARIA-256-GCM-SHA384
TLS-RSA-PSK-WITH-CAMELLIA-128-CBC-SHA256
TLS-RSA-PSK-WITH-CAMELLIA-128-GCM-SHA256
TLS-RSA-PSK-WITH-CAMELLIA-256-CBC-SHA384
TLS-RSA-PSK-WITH-CAMELLIA-256-GCM-SHA384
TLS-RSA-PSK-WITH-CHACHA20-POLY1305-SHA256
TLS-RSA-PSK-WITH-NULL-SHA
TLS-RSA-PSK-WITH-NULL-SHA256
TLS-RSA-PSK-WITH-NULL-SHA384
TLS-RSA-WITH-AES-128-CBC-SHA
TLS-RSA-WITH-AES-128-CBC-SHA256
TLS-RSA-WITH-AES-128-CCM
TLS-RSA-WITH-AES-128-CCM-8
TLS-RSA-WITH-AES-128-GCM-SHA256
TLS-RSA-WITH-AES-256-CBC-SHA
TLS-RSA-WITH-AES-256-CBC-SHA256
TLS-RSA-WITH-AES-256-CCM
TLS-RSA-WITH-AES-256-CCM-8
TLS-RSA-WITH-AES-256-GCM-SHA384
TLS-RSA-WITH-ARIA-128-CBC-SHA256
TLS-RSA-WITH-ARIA-128-GCM-SHA256
TLS-RSA-WITH-ARIA-256-CBC-SHA384
TLS-RSA-WITH-ARIA-256-GCM-SHA384
TLS-RSA-WITH-CAMELLIA-128-CBC-SHA
TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256
TLS-RSA-WITH-CAMELLIA-128-GCM-SHA256
TLS-RSA-WITH-CAMELLIA-256-CBC-SHA
TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256
TLS-RSA-WITH-CAMELLIA-256-GCM-SHA384
TLS-RSA-WITH-NULL-MD5
TLS-RSA-WITH-NULL-SHA
TLS-RSA-WITH-NULL-SHA256
```

As a consequence of the removal of support for DHE in (D)TLS 1.2, the following functions are no longer useful and have been removed:

```
mbedtls_ssl_conf_dh_param_bin()
mbedtls_ssl_conf_dh_param_ctx()
mbedtls_ssl_conf_dhm_min_bitlen()
```
