Migrating from Mbed TLS 2.x to Mbed TLS 3.0
===========================================

This guide details the steps required to migrate from Mbed TLS version 2.x to
Mbed TLS version 3.0 or greater. Unlike normal releases, Mbed TLS 3.0 breaks
compatibility with previous versions, so users (and alt implementors) might
need to change their own code in order to make it work with Mbed TLS 3.0.

Here's the list of breaking changes; each entry should help you answer these
two questions: (1) am I affected? (2) if yes, what's my migration path?

Some function parameters were made const
----------------------------------------

Various functions in the PK and ASN.1 modules had a `const` qualifier added to
some of their parameters.

This normally doesn't affect your code, unless you use pointers to reference
those functions. In this case, you'll need to update the type of your pointers
in order to match the new signature.

Deprecated functions were removed from hashing modules
------------------------------------------------------

Modules: MD5, SHA1, SHA256, SHA512, MD.

- The functions `mbedtls_xxx_starts()`, `mbedtls_xxx_update()`,
  `mbedtls_xxx_finish()` and `mbedtls_xxx()` were removed. Please use the
function with the same name with `_ret` appended and check the return value.
- The function `mbedtls_md_init_ctx()` was removed; please use
  `mbedtls_md_setup()` instead.
- The functions `mbedtls_xxx_process()` were removed. You normally don't need
  to call that from application code. However if you do (or if you want to
provide your own version of that function), please use
`mbedtls_internal_xxx_process()` instead, and check the return value.

Deprecated error codes for hardware failures were removed
---------------------------------------------------------

- The macros `MBEDTLS_ERR_xxx_FEATURE_UNSUPPORTED` from various crypto modules
  were removed; `MBEDTLS_ERR_PLATFORM_FEATURE_UNSUPPORTED` is now used
instead.
- The macros `MBEDTLS_ERR_xxx_HW_ACCEL_FAILED` from various crypto modules
  were removed; `MBEDTLS_ERR_PLATFORM_HW_ACCEL_FAILED` is now used instead.

Deprecated names for PSA constants and types were removed
---------------------------------------------------------

Some constants and types that were present in beta versions of the PSA Crypto
API were removed from version 1.0 of specification. Please switch to the new
names provided by the 1.0 specification instead.

Internal / alt-focused headers were moved to a private location
----------------------------------------------------------------

This shouldn't affect users who took care not to include headers that
were documented as internal, despite being in the public include directory.

If you're providing alt implementations of ECP or RSA, you'll need to add our
`library` directory to your include path when building your alt
implementations, and note that `ecp_internal.h` and `rsa_internal.h` have been
renamed to `ecp_internal_alt.h` and `rsa_alt_helpers.h` respectively.

If you're a library user and used to rely on having access to a structure or
function that's now in a private header, please reach out on the mailing list
and explain your need; we'll consider adding a new API in a future version.

Remove the certs module from the library
----------------------------------------

This should not affect production use of the library, as the certificates and
keys included there were never suitable for production use.

However it might affect you if you relied on them for testing purposes. In
that case, please embed your own test certificates in your test code; now that
`certs.c` is out of the library there is no longer any stability guaranteed
and it may change in incompatible ways at any time.

Remove the HAVEGE module
------------------------

This doesn't affect people using the default configuration as it was already
disabled by default.

This only affects users who called the HAVEGE modules directly (not
recommended), or users who used it through the entropy module but had it as the
only source of entropy. If you're in that case, please declare OS or hardware
RNG interfaces with `mbedtls_entropy_add_source()` and/or use an entropy seed
file created securely during device provisioning. See
<https://tls.mbed.org/kb/how-to/add-entropy-sources-to-entropy-pool> for more
information.

Remove support for parsing SSLv2 ClientHello
--------------------------------------------

This doesn't affect people using the default configuration as it was already
disabled by default.

This only affects TLS servers that have clients who send an SSLv2 ClientHello.
These days clients are very unlikely to do that. If you have a client that
does, please try contacting them and encouraging them to upgrade their
software.

Remove support for SSL 3.0
--------------------------

This doesn't affect people using the default configuration as it was already
disabled by default.

This only affects TLS users who explicitly enabled `MBEDTLS_SSL_PROTO_SSL3`
and relied on that version in order to communicate with peers that are not up
to date. If one of your peers is in that case, please try contacting them and
encouraging them to upgrade their software.

Remove support for truncated HMAC
---------------------------------

This affects users of truncated HMAC, that is, users who called
`mbedtls_ssl_conf_truncated_hmac( ..., MBEDTLS_SSL_TRUNC_HMAC_ENABLED)`,
regardless of whether the standard version was used or compatibility version
(`MBEDTLS_SSL_TRUNCATED_HMAC_COMPAT`).

The recommended migration path for people who want minimal overhead is to use a
CCM-8 ciphersuite.

Remove support for TLS record-level compression
-----------------------------------------------

This doesn't affect people using the default configuration as it was already
disabled by default.

This only affects TLS users who enabled `MBEDTLS_ZLIB_SUPPORT`. This will not
cause any failures however if you used to enable TLS record-level compression
you may find that your bandwidth usage increases without compression. There's
no general solution to this problem; application protocols might have their
own compression mechanisms and are in a better position than the TLS stack to
avoid variants of the CRIME and BREACH attacks.

Remove support for TLS RC4-based ciphersuites
---------------------------------------------

This does not affect people who used the default `config.h` and the default
list of ciphersuites, as RC4-based ciphersuites were already not negotiated in
that case.

Please switch to any of the modern, recommended ciphersuites (based on
AES-GCM, AES-CCM or ChachaPoly for example) and if your peer doesn't support
any, encourage them to upgrade their software.

Remove support for TLS single-DES ciphersuites
----------------------------------------------

This doesn't affect people using the default configuration as it was already
disabled by default.

Please switch to any of the modern, recommended ciphersuites (based on
AES-GCM, AES-CCM or ChachaPoly for example) and if your peer doesn't support
any, encourage them to upgrade their software.

Remove support for TLS record-level hardware acceleration
---------------------------------------------------------

This doesn't affect people using the default configuration as it was already
disabled by default.

This feature had been broken for a while so we doubt anyone still used it.
However if you did, please reach out on the mailing list and let us know about
your use case.

Remove wrapper for libpkcs11-helper
-----------------------------------

This doesn't affect people using the default configuration as it was already
disabled by default.

If you used to rely on this module in order to store your private keys
securely, please have a look at the key management facilities provided by the
PSA crypto API. If you have a use case that's not covered yet by this API,
please reach out on the mailing list.

Remove config option `MBEDTLS_SSL_DEFAULT_TICKET_LIFETIME`
----------------------------------------------------------

This doesn't affect people using the default configuration.

This option has not had any effect for a long time. Please use the `lifetime`
parameter of `mbedtls_ssl_ticket_setup()` instead.

Remove helpers for the transition from Mbed TLS 1.3 to Mbed TLS 2.0
-------------------------------------------------------------------

This only affects people who've been using Mbed TLS since before version 2.0
and still relied on `compat-1.3.h` in their code.

Please use the new names directly in your code; `scripts/rename.pl` (from any
of the 2.x releases - no longer included in 3.0) might help you do that.
